/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.util;

import ch.elinchrom.EL_Updater_Main;
import ch.elinchrom.firmware_updater.Firmware_Updater;
import ch.elinchrom.info.Elinchrom_HID_Device;
import ch.elinchrom.info.HID_Bootloader_Commands;
import ch.elinchrom.logging.LogWrapper;
import com.sun.jna.Platform;
import elinchrom.Identifiers;
import elinchrom.Skyport_Module;
import elinchrom.Unit_Prototype_Json;
import firmware_updater.Jni_macosx_functions;
import firmware_updater.Jni_windows_functions;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class Elinchrom_Utils {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static ResourceBundle labels = ResourceBundle.getBundle("localized_strings/LabelsBundle", Locale.getDefault());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count_connected_elinchrom_units() {
        Context context = new Context();
        int result = LibUsb.init(context);
        int num_connected_elinchrom_devices = 0;
        if (result < 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        DeviceList list = new DeviceList();
        result = LibUsb.getDeviceList(context, list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device device : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor(device, descriptor = new DeviceDescriptor());
                if (result < 0) {
                    throw new LibUsbException("Unable to read device descriptor", result);
                }
                if (descriptor.idVendor() != 10924) continue;
                ++num_connected_elinchrom_devices;
            }
        }
        finally {
            LibUsb.freeDeviceList(list, true);
        }
        LibUsb.exit(context);
        return num_connected_elinchrom_devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short check_connected_device_type() {
        Context context = new Context();
        short product = 0;
        int result = LibUsb.init(context);
        if (result < 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        DeviceList list = new DeviceList();
        result = LibUsb.getDeviceList(context, list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device device : list) {
                DeviceDescriptor descriptor;
                result = LibUsb.getDeviceDescriptor(device, descriptor = new DeviceDescriptor());
                if (result < 0) {
                    throw new LibUsbException("Unable to read device descriptor", result);
                }
                if (descriptor.idVendor() != 10924) continue;
                product = descriptor.idProduct();
                short s = descriptor.idProduct();
                return s;
            }
        }
        finally {
            LibUsb.freeDeviceList(list, true);
        }
        LibUsb.exit(context);
        return product;
    }

    public static void open_hid_device_connection(Elinchrom_HID_Device unit, short device_pid) {
        try {
            unit.setHidServices(HidManager.getHidServices());
            HidDevice hidDevice = unit.getHidServices().getHidDevice(10924, device_pid, null);
            unit.setHidDevice(hidDevice);
            if (unit.getHidDevice() != null) {
                unit.setIsHidDevice(true);
            }
        }
        catch (HidException hidException) {
            // empty catch block
        }
    }

    public static void read_hid_unit_data(Elinchrom_HID_Device unit) throws HidException {
        byte[] message = new byte[Skyport_Module.BUFFER_SIZE];
        for (int i = 0; i < Skyport_Module.BUFFER_SIZE; ++i) {
            message[i] = 0;
        }
        if (Platform.isWindows()) {
            message[0] = 0;
            message[1] = HID_Bootloader_Commands.QUERY_DEVICE;
            message[2] = 0;
        } else {
            message[0] = HID_Bootloader_Commands.QUERY_DEVICE;
            message[1] = 0;
        }
        int val = unit.getHidDevice().write(message, Skyport_Module.BUFFER_SIZE, (byte)0);
        if (val == -1) {
            System.err.println(unit.getHidDevice().getLastErrorMessage());
        }
        byte[] data = new byte[Skyport_Module.BUFFER_SIZE];
        val = unit.getHidDevice().read(data, 150);
        Elinchrom_Utils.set_plugged_unit_info(unit, data);
    }

    private static void set_plugged_unit_info(Elinchrom_HID_Device plugged_unit, byte[] message) throws HidException {
        byte[] bootloader_rev = new byte[]{message[4], message[3]};
        byte[] application_rev = new byte[]{message[6], message[5]};
        byte[] skyport_serial_num = new byte[]{message[12], message[11], message[10], message[9]};
        byte[] app_start_address = new byte[]{message[16], message[15], message[14], message[13]};
        byte[] app_end_address = new byte[]{message[20], message[19], message[18], message[17]};
        byte[] size_page_erase = new byte[]{message[22], message[21]};
        byte[] size_row_prog = new byte[]{message[24], message[23]};
        String app_revision = Elinchrom_Utils.bytesToHexString(application_rev);
        String bootloader_revision = Elinchrom_Utils.bytesToHexString(bootloader_rev);
        app_revision = !app_revision.equals("ffff") ? Elinchrom_Utils.format_revision(app_revision) : "No FW";
        String unit_name = EL_Updater_Main.get_unit_name(message[7] & 0xFF);
        bootloader_revision = Elinchrom_Utils.format_revision(bootloader_revision);
        plugged_unit.setCommand(message[0]);
        plugged_unit.setMCU_Family(message[1]);
        plugged_unit.setFirmware_type(message[2]);
        plugged_unit.setBootloader_Rev(bootloader_revision);
        plugged_unit.setApplication_Rev(app_revision);
        plugged_unit.setProduct_id(message[7] & 0xFF);
        plugged_unit.setSkyport_ID(message[8]);
        plugged_unit.setSkyport_Serial_Num(Elinchrom_Utils.bytesToHexString(skyport_serial_num));
        plugged_unit.setApp_Start_Address(Elinchrom_Utils.bytesToHexString(app_start_address));
        plugged_unit.setApp_End_Address(Elinchrom_Utils.bytesToHexString(app_end_address));
        plugged_unit.setSize_Page_Erase(Elinchrom_Utils.bytesToHexString(size_page_erase));
        plugged_unit.setSize_Row_Prog(Elinchrom_Utils.bytesToHexString(size_row_prog));
        plugged_unit.setSize_Data_Packet(message[25]);
        plugged_unit.setBytes_Per_Addr(message[26]);
        plugged_unit.setModel_full_name(unit_name);
        Unit_Prototype_Json temp = (Unit_Prototype_Json)Skyport_Module.elinchrom_units_prototypes.get(EL_Updater_Main.plugged_hid_unit.getProduct_id());
        plugged_unit.setImage_URL(temp.getImage_URL());
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isWindows10() {
        return OS.equals("windows 10");
    }

    public static boolean check_internet_connection() {
        try {
            URL url = new URL("http://www.elinchrom.com");
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            Object object = urlConnect.getContent();
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String removeDiacriticalMarks(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String format_revision(String rev) {
        String id1 = rev.substring(0, 1);
        String id2 = rev.substring(1, 2);
        String id3 = rev.substring(2, 3);
        String id4 = rev.substring(3, rev.length());
        Object result = "";
        result = Integer.parseInt(id1) == 0 ? (String)result + id2 + "." : (String)result + id1 + id2 + ".";
        result = Integer.parseInt(id3) == 0 ? (String)result + id4 : (String)result + id3 + id4;
        return result;
    }

    public static void check_new_updater_available(String updaterNewsUrl) {
        Object[] new_updater_choices = new String[]{"Download now", "Next Time"};
        try {
            URL url = new URL(updaterNewsUrl);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String web_rev = br.readLine();
            String current_release_notes = br.readLine();
            String windows_download = br.readLine();
            windows_download = windows_download.split(":")[1];
            String mac_osx_download = br.readLine();
            mac_osx_download = mac_osx_download.split(":")[1];
            web_rev = web_rev.split(":")[1];
            if (Elinchrom_Utils.isLeftNewer(web_rev, EL_Updater_Main.EL_Updater_Version)) {
                int reply = JOptionPane.showOptionDialog(null, labels.getString("new_sw_msg") + current_release_notes + labels.getString("ask_new_sw_msg"), labels.getString("new_sw_window"), 0, 2, null, new_updater_choices, "");
                switch (reply) {
                    case 0: {
                        if (Elinchrom_Utils.isWindows()) {
                            Elinchrom_Utils.openWebpage(new URL(Identifiers.ELINCHROM_USB_DEVICES_URL + windows_download));
                        } else {
                            Elinchrom_Utils.openWebpage(new URL(Identifiers.ELINCHROM_USB_DEVICES_URL + mac_osx_download));
                        }
                        JOptionPane.showMessageDialog(null, "Thanks for updating. \n Please follow the instructions in your browser \n and at the end of the download restart the newly downloaded EL-Updater.");
                        System.exit(0);
                        break;
                    }
                }
            }
        }
        catch (MalformedURLException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (IOException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LogWrapper.getLogger(Firmware_Updater.class.getName()).log(Level.SEVERE, null, (Throwable)ex);
        }
    }

    public static boolean isLeftNewer(String left, String right) {
        String[] _left = left.split("\\.");
        String[] _right = right.split("\\.");
        for (int i = 0; i < _left.length; ++i) {
            int r;
            int l = Integer.parseInt(_left[i]);
            int n = r = i < _right.length ? Integer.parseInt(_right[i]) : 0;
            if (l < r) {
                return false;
            }
            if (l <= r) continue;
            return true;
        }
        return false;
    }

    public static void update_ELSP_device_info() {
        File[] f2;
        FileSystemView fsv = FileSystemView.getFileSystemView();
        for (File f1 : f2 = File.listRoots()) {
            if (!fsv.getSystemDisplayName(f1).contains("Elinchrom")) continue;
            EL_Updater_Main.elsp_drive_id = f1.toString().replace("\\", "");
        }
        String device_info = Elinchrom_Utils.isWindows() ? Jni_windows_functions.read_information_sector(EL_Updater_Main.elsp_drive_id) : Jni_macosx_functions.read_information_sector("not_needed");
        String fw_rev = device_info.substring(8, 16);
        fw_rev = fw_rev.replace("BETA", "");
        fw_rev = fw_rev.replaceAll("\\s", "");
        String hw_rev = device_info.substring(16, 24);
        hw_rev = hw_rev.replace("BETA", "");
        hw_rev = hw_rev.replaceAll("\\s", "");
        hw_rev = hw_rev.replace(".", "");
        EL_Updater_Main.plugged_elsp_hs.setApplication_Rev(fw_rev.replace("BETA", ""));
        EL_Updater_Main.plugged_elsp_hs.setBootloader_Rev(hw_rev);
    }

    public static int check_firmware_file(String header, List<String> firmwareIdList, String fw_revision) {
        if (!header.equals("Elinchrom Firmware")) {
            return 1;
        }
        if (!firmwareIdList.contains(Integer.toString(EL_Updater_Main.plugged_hid_unit.getProduct_id()))) {
            return 2;
        }
        if (EL_Updater_Main.plugged_hid_unit.getApplication_Rev().equals("No FW")) {
            return 4;
        }
        if (EL_Updater_Main.plugged_hid_unit.getApplication_Rev().charAt(0) == '0' && EL_Updater_Main.plugged_hid_unit.getApplication_Rev().length() == 4) {
            int available_fw_rev = Integer.parseInt(fw_revision.replace(".", ""));
            if (available_fw_rev * 10 > Elinchrom_Utils.hexStringToByteArray(EL_Updater_Main.plugged_hid_unit.getApplication_Rev().replace(".", "0"))[1]) {
                return 4;
            }
            return 3;
        }
        if (Integer.parseInt(EL_Updater_Main.plugged_hid_unit.getApplication_Rev().replace(".", "")) > Integer.parseInt(fw_revision.replace(".", ""))) {
            return 3;
        }
        return 4;
    }

    private static void openWebpage(URL url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = url.toURI();
                desktop.browse(uri);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }
}

