/*
 * Decompiled with CFR 0.152.
 */
package ch.elinchrom.util;

import ch.elinchrom.EL_Updater_Main;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NativeUtils {
    private NativeUtils() {
    }

    public static File createTempDir(String dirName) throws IOException {
        File tempFile = File.createTempFile(dirName + "_", "");
        File tempDir = new File(tempFile.getParent() + File.separator + dirName);
        tempDir.mkdir();
        tempDir.deleteOnExit();
        tempFile.deleteOnExit();
        return tempDir;
    }

    public static void loadLibraryFromJar(String path) throws IOException {
        NativeUtils.loadLibraryFromJar(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File loadLibraryFromJar(String path, boolean asRawFile) throws IOException {
        File result = null;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeUtils.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        if (asRawFile) {
            result = temp;
        } else if (path.contains("EXE")) {
            EL_Updater_Main.driver_exe_file_path = temp.getPath();
        } else if (path.contains("pkg")) {
            EL_Updater_Main.driver_exe_file_path = temp.getPath();
        } else if (path.contains("zip")) {
            EL_Updater_Main.driver_exe_file_path = temp.getPath();
            EL_Updater_Main.driver_exe_pathname = temp.getParent();
            EL_Updater_Main.driver_exe_file_name = temp.getName();
        } else if (path.contains("ps1")) {
            EL_Updater_Main.driver_exe_file_path = temp.getPath();
            EL_Updater_Main.driver_exe_pathname = temp.getParent();
            EL_Updater_Main.driver_exe_file_name = temp.getName();
        } else {
            System.load(temp.getAbsolutePath());
        }
        final String libraryPrefix = prefix;
        String lockSuffix = ".lock";
        File lock = new File(temp.getAbsolutePath() + ".lock");
        lock.createNewFile();
        lock.deleteOnExit();
        FileFilter tmpDirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(libraryPrefix) && !pathname.getName().endsWith(".lock");
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File[] tmpFiles = tmpDir.listFiles(tmpDirFilter);
        for (int i = 0; i < tmpFiles.length; ++i) {
            File lockFile = new File(tmpFiles[i].getAbsolutePath() + ".lock");
            if (lockFile.exists()) continue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileFromJar(String pathInJar, File destinationFile) throws IOException {
        byte[] buffer = new byte[1024];
        InputStream is = NativeUtils.class.getResourceAsStream(pathInJar);
        if (is == null) {
            throw new FileNotFoundException("File " + pathInJar + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(destinationFile);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
    }
}

