/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray$JsonParser;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String json) {
        this(new StringReader(json));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError e) {
            char[] cArray = "\u7519\u9873\u04c3\ua7ab\u07e6\u7116\u2116\uda36\uf103\ub9e8\u1f95\u2504\u7d9b\u8de9\u8ae6\uf919\u4606\u4005\u2c46\u7560\u2247\u6576\udef7\u3e13\u5a20\u939d\ud8c3\ud92f\uc7b9\ub0e0\u59fb\u5546\ud022\uf123".toCharArray();
            cArray[20] = (char)(cArray[20] ^ 0x73B7);
            throw new JsonParseException(JsonArray$JsonParser.C(cArray, 5818 << 16 | 0x1AEF, (short)2, (byte)4), e);
        }
        catch (OutOfMemoryError e) {
            char[] cArray = "\u9cfd\ub7de\u2754\ub038\u5584\ua1de\u2fee\ubab3\uc7dc\ue9db\uc5ba\u150c\udd26\u5247\u334d\ucd1b\uc390\udd7e\uc17c\u2c07\u5c40\uf03e\uf81b\u53db\u293d\u1eb1\u150c\u430b\ub70c\u0bd2\u061a\u90c6\ua9e1\u9cb8".toCharArray();
            cArray[5] = (char)(cArray[5] ^ 0x3369);
            throw new JsonParseException(JsonArray$JsonParser.C(cArray, 19259 << 16 | 0x365B, (short)2, (byte)0), e);
        }
        catch (JsonParseException e) {
            throw e.getCause() instanceof EOFException ? new NoSuchElementException() : e;
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

