/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper;
import com.google.gson.internal.bind.TreeTypeAdapter$TreeTypeAdapter;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new Writer(){

        @Override
        public void write(char[] buffer, int offset, int counter) {
            throw new AssertionError();
        }

        @Override
        public void flush() throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private static final JsonPrimitive SENTINEL_CLOSED;
    private final List<JsonElement> stack = new ArrayList<JsonElement>();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    public JsonElement get() {
        if (!this.stack.isEmpty()) {
            char[] cArray = "\u45f1\u0b2f\u1df1\ufed4\ua7c9\ub1b1\udcd6\u590a\u5de2\u06a6\u1e4d\uc649\u4fcd\uaeb3\u62af\u362e\u4786\ud6b4\ub4ed\ubfc0\u5432\uf2c6\uff78\u7f19\u76e7\u8e65\ue18a\u7e75\u383a\uffb8\ucd19\u109b\u44f1\u20c2".toCharArray();
            cArray[12] = (char)(cArray[12] ^ 0x2E71);
            throw new IllegalStateException(TypeAdapterRuntimeTypeWrapper$TreeTypeAdapter.V(cArray, 8578 << 16 | 0xE13, (short)1, 4) + this.stack);
        }
        return this.product;
    }

    private JsonElement peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private void put(JsonElement value) {
        if (this.pendingName != null) {
            if (!value.isJsonNull() || this.getSerializeNulls()) {
                JsonObject object = (JsonObject)this.peek();
                object.add(this.pendingName, value);
            }
            this.pendingName = null;
        } else if (this.stack.isEmpty()) {
            this.product = value;
        } else {
            JsonElement element = this.peek();
            if (element instanceof JsonArray) {
                ((JsonArray)element).add(value);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public JsonWriter beginArray() throws IOException {
        JsonArray array = new JsonArray();
        this.put(array);
        this.stack.add(array);
        return this;
    }

    @Override
    public JsonWriter endArray() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.peek();
        if (element instanceof JsonArray) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonWriter beginObject() throws IOException {
        JsonObject object = new JsonObject();
        this.put(object);
        this.stack.add(object);
        return this;
    }

    @Override
    public JsonWriter endObject() throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.peek();
        if (element instanceof JsonObject) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonWriter name(String name) throws IOException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement element = this.peek();
        if (element instanceof JsonObject) {
            this.pendingName = name;
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.put(new JsonPrimitive(value));
        return this;
    }

    @Override
    public JsonWriter nullValue() throws IOException {
        this.put(JsonNull.INSTANCE);
        return this;
    }

    @Override
    public JsonWriter value(boolean value) throws IOException {
        this.put(new JsonPrimitive(value));
        return this;
    }

    @Override
    public JsonWriter value(Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.put(new JsonPrimitive(value));
        return this;
    }

    @Override
    public JsonWriter value(double value) throws IOException {
        if (!this.isLenient() && (Double.isNaN(value) || Double.isInfinite(value))) {
            char[] cArray = "\uaed8\u19ad\u62df\u2dd4\ufa99\u9f25\ue2da\udcc0\u4626\u07d7\ue508\u3a61\uce77\u92db\u89f9\u7a7a\uf123\u6dc3\ub712\ue0a6\u6168\uc366\u39b9\u1f9c\uba5c\u1a5a\u2df3\u3292\udeb4\u6882\u2a84\u076c\u793d".toCharArray();
            cArray[24] = (char)(cArray[24] ^ 0x1997);
            throw new IllegalArgumentException(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 26632 << 16 | 0x49DA, (short)3, (byte)4) + value);
        }
        this.put(new JsonPrimitive(value));
        return this;
    }

    @Override
    public JsonWriter value(long value) throws IOException {
        this.put(new JsonPrimitive(value));
        return this;
    }

    @Override
    public JsonWriter value(Number value) throws IOException {
        double d;
        if (value == null) {
            return this.nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            char[] cArray = "\ufc07\u42a8\u0ff5\ufab3\ubd22\u5306\u30a5\u4bc0\u1537\uabc9\ue550\u1b9f\u0d25\ueb78\u4e3c\u1751\u3f85\u6a52\u4cc3\u486d\u19e4\u328e\uc79a\ubf0a\ub1a4\u49ed\u9baf\ufbb6\uf16a\ue740\u9bc8\u4dd4\ua415".toCharArray();
            cArray[28] = (char)(cArray[28] ^ 0x10AC);
            throw new IllegalArgumentException(TreeTypeAdapter$TreeTypeAdapter.N(cArray, 8117 << 16 | 0x1930, 2, (byte)3) + value);
        }
        this.put(new JsonPrimitive(value));
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (!this.stack.isEmpty()) {
            char[] cArray = "\ud7b8\uab37\ubc7d\u4a9e\u81cd\u96d5\u64ec\uef5d\u5cfc\ua599\u9655\ufdd8\ua470\u08d9\u575a\u6b07\u9eb4\u9e0f\uac04".toCharArray();
            cArray[17] = (char)(cArray[17] ^ 0x140D);
            throw new IOException(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 25132 << 16 | 0x4F4D, (short)3, (byte)4));
        }
        this.stack.add(SENTINEL_CLOSED);
    }

    static {
        char[] cArray = "\u0f67\ue5c8\ucbd5\u346b\u4e0e\u4540".toCharArray();
        cArray[2] = (char)(cArray[2] ^ 0x5B64);
        SENTINEL_CLOSED = new JsonPrimitive(ArrayTypeAdapter$TypeAdapterRuntimeTypeWrapper.N(cArray, 14573 << 16 | 0x4A7E, (short)2, (byte)2));
    }
}

