/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind.util;

import com.google.gson.internal.bind.util.g;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String UTC_ID;
    private static final TimeZone TIMEZONE_UTC;

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean millis) {
        return ISO8601Utils.format(date, millis, TIMEZONE_UTC);
    }

    public static String format(Date date, boolean millis, TimeZone tz) {
        int offset;
        int n;
        int n2;
        GregorianCalendar calendar = new GregorianCalendar(tz, Locale.US);
        calendar.setTime(date);
        char[] cArray = "\u93b1\u5f6b\ufab9\ua568\uba5d\ud08c\u4e73\ua5eb\u5099\uad4f\u4d1b\u40c8\u5e08\u0a4a\ub786\uc809\u72ea\ucdd6\ud382".toCharArray();
        cArray[10] = (char)(cArray[10] ^ 0x72BB);
        int capacity = g.Q(cArray, 26555 << 16 | 0x1D81, (short)4, (short)5).length();
        if (millis) {
            char[] cArray2 = "\u8a47\uabed\u8d79\u63b0".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x3B5E);
            n2 = g.Q(cArray2, 4969 << 16 | 0x1D90, (short)5, (short)5).length();
        } else {
            n2 = 0;
        }
        capacity += n2;
        if (tz.getRawOffset() == 0) {
            char[] cArray3 = "\ue597".toCharArray();
            cArray3[0] = (char)(cArray3[0] ^ 0x5BB6);
            n = g.Q(cArray3, 12348 << 16 | 0xAD6, (short)2, (short)2).length();
        } else {
            char[] cArray4 = "\uef32\u66fc\u4337\uf552\ub855\ub676".toCharArray();
            cArray4[5] = (char)(cArray4[5] ^ 0x1BDC);
            n = g.Q(cArray4, 30067 << 16 | 0x214C, (short)3, (short)4).length();
        }
        StringBuilder formatted = new StringBuilder(capacity += n);
        char[] cArray5 = "\ue8d2\u7bdf\u39c9\u37fb".toCharArray();
        cArray5[3] = (char)(cArray5[3] ^ 0x3564);
        ISO8601Utils.padInt(formatted, calendar.get(1), g.Q(cArray5, 1896 << 16 | 0x5C0A, (short)5, (short)0).length());
        formatted.append('-');
        char[] cArray6 = "\u53a3\u16d1".toCharArray();
        cArray6[1] = (char)(cArray6[1] ^ 0x1026);
        ISO8601Utils.padInt(formatted, calendar.get(2) + 1, g.Q(cArray6, 11565 << 16 | 0x4574, (short)0, (short)4).length());
        formatted.append('-');
        char[] cArray7 = "\uf6ac\ud90e".toCharArray();
        cArray7[1] = (char)(cArray7[1] ^ 0x31B3);
        ISO8601Utils.padInt(formatted, calendar.get(5), g.Q(cArray7, 25565 << 16 | 0x6821, (short)5, (short)4).length());
        formatted.append('T');
        char[] cArray8 = "\u547b\u1d69".toCharArray();
        cArray8[0] = (char)(cArray8[0] ^ 0x2153);
        ISO8601Utils.padInt(formatted, calendar.get(11), g.Q(cArray8, 27445 << 16 | 0x7504, (short)4, (short)5).length());
        formatted.append(':');
        char[] cArray9 = "\u3a8f\u0ebe".toCharArray();
        cArray9[0] = (char)(cArray9[0] ^ 0x645C);
        ISO8601Utils.padInt(formatted, calendar.get(12), g.Q(cArray9, 19091 << 16 | 0x66DB, (short)1, (short)1).length());
        formatted.append(':');
        char[] cArray10 = "\u78d3\u98af".toCharArray();
        cArray10[0] = (char)(cArray10[0] ^ 0x617);
        ISO8601Utils.padInt(formatted, calendar.get(13), g.Q(cArray10, 22981 << 16 | 0x4B2B, (short)4, (short)3).length());
        if (millis) {
            formatted.append('.');
            char[] cArray11 = "\ubf28\ub8e7\u0801".toCharArray();
            cArray11[2] = (char)(cArray11[2] ^ 0x3ABB);
            ISO8601Utils.padInt(formatted, calendar.get(14), g.Q(cArray11, 12236 << 16 | 0x2DC, (short)5, (short)3).length());
        }
        if ((offset = tz.getOffset(calendar.getTimeInMillis())) != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            formatted.append(offset < 0 ? (char)'-' : '+');
            char[] cArray12 = "\u2985\uc912".toCharArray();
            cArray12[0] = (char)(cArray12[0] ^ 0x51AC);
            ISO8601Utils.padInt(formatted, hours, g.Q(cArray12, 21083 << 16 | 0x32B0, (short)2, (short)2).length());
            formatted.append(':');
            char[] cArray13 = "\u90ea\u448d".toCharArray();
            cArray13[1] = (char)(cArray13[1] ^ 0x122E);
            ISO8601Utils.padInt(formatted, minutes, g.Q(cArray13, 32572 << 16 | 0x3628, (short)3, (short)0).length());
        } else {
            formatted.append('Z');
        }
        return formatted.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static Date parse(String date, ParsePosition pos) throws ParseException {
        fail = null;
        try {
            block28: {
                block29: {
                    block27: {
                        offset = pos.getIndex();
                        year = ISO8601Utils.parseInt(date, offset, offset += 4);
                        if (ISO8601Utils.checkOffset(date, offset, '-')) {
                            // empty if block
                        }
                        month = ISO8601Utils.parseInt(date, ++offset, offset += 2);
                        if (ISO8601Utils.checkOffset(date, offset, '-')) {
                            // empty if block
                        }
                        day = ISO8601Utils.parseInt(date, ++offset, offset += 2);
                        hour = 0;
                        minutes = 0;
                        seconds = 0;
                        milliseconds = 0;
                        hasT = ISO8601Utils.checkOffset(date, offset, 'T');
                        if (!hasT && date.length() <= offset) {
                            calendar = new GregorianCalendar(year, month - 1, day);
                            pos.setIndex(offset);
                            return calendar.getTime();
                        }
                        if (hasT) {
                            hour = ISO8601Utils.parseInt(date, ++offset, offset += 2);
                            if (ISO8601Utils.checkOffset(date, offset, ':')) {
                                // empty if block
                            }
                            minutes = ISO8601Utils.parseInt(date, ++offset, offset += 2);
                            if (ISO8601Utils.checkOffset(date, offset, ':')) {
                                ++offset;
                            }
                            if (date.length() > offset && (c = date.charAt(offset)) != 'Z' && c != '+' && c != '-') {
                                if ((seconds = ISO8601Utils.parseInt(date, offset, offset += 2)) > 59 && seconds < 63) {
                                    seconds = 59;
                                }
                                if (ISO8601Utils.checkOffset(date, offset, '.')) {
                                    endOffset = ISO8601Utils.indexOfNonDigit(date, ++offset + 1);
                                    parseEndOffset = Math.min(endOffset, offset + 3);
                                    fraction = ISO8601Utils.parseInt(date, offset, parseEndOffset);
                                    switch (parseEndOffset - offset) {
                                        case 2: {
                                            milliseconds = fraction * 10;
                                            break;
                                        }
                                        case 1: {
                                            milliseconds = fraction * 100;
                                            break;
                                        }
                                        default: {
                                            milliseconds = fraction;
                                        }
                                    }
                                    offset = endOffset;
                                }
                            }
                        }
                        if (date.length() <= offset) {
                            v0 = "\u1c08\ue1a1\u1572\u1437\uc5a8\ua580\ua326\u3c3a\ub856\u7c7f\ud125\ue1f0\u2f00\u8823\u8ae2\ua66e\uc090\u943d\u73b1\u5add\u4849\uc3b4".toCharArray();
                            v0[13] = (char)(v0[13] ^ 26763);
                            throw new IllegalArgumentException(g.Q(v0, 14416 << 16 | 17253, (short)1, (short)1));
                        }
                        timezone = null;
                        timezoneIndicator = date.charAt(offset);
                        if (timezoneIndicator != 'Z') break block27;
                        timezone = ISO8601Utils.TIMEZONE_UTC;
                        ++offset;
                        break block28;
                    }
                    if (timezoneIndicator != '+' && timezoneIndicator != '-') break block29;
                    timezoneOffset = date.substring(offset);
                    if (timezoneOffset.length() >= 5) {
                        v1 = timezoneOffset;
                    } else {
                        v2 = "\u931a\u3586".toCharArray();
                        v2[0] = (char)(v2[0] ^ 24426);
                        v1 = timezoneOffset + g.Q(v2, 25442 << 16 | 30293, (short)1, (short)3);
                    }
                    timezoneOffset = v1;
                    offset += timezoneOffset.length();
                    v3 = "\ubf01\ua06d\u8563\u47cc\u0115".toCharArray();
                    v3[0] = (char)(v3[0] ^ 25713);
                    if (g.Q(v3, 1136 << 16 | 21469, (short)2, (short)0).equals(timezoneOffset)) ** GOTO lbl-1000
                    v4 = "\ub0ca\u101b\u9864\ud3a6\u2edb\u5200".toCharArray();
                    v4[3] = (char)(v4[3] ^ 12475);
                    if (g.Q(v4, 9628 << 16 | 11984, (short)3, (short)3).equals(timezoneOffset)) lbl-1000:
                    // 2 sources

                    {
                        timezone = ISO8601Utils.TIMEZONE_UTC;
                    } else {
                        v5 = "\uae54\u4c12\uc3cc".toCharArray();
                        v5[1] = (char)(v5[1] ^ 25030);
                        timezoneId = g.Q(v5, 21552 << 16 | 17653, (short)2, (short)2) + timezoneOffset;
                        timezone = TimeZone.getTimeZone(timezoneId);
                        act = timezone.getID();
                        if (!act.equals(timezoneId)) {
                            v6 = "\u115c".toCharArray();
                            v6[0] = (char)(v6[0] ^ 20081);
                            cleaned = act.replace(g.Q(v6, 31927 << 16 | 24826, (short)2, (short)1), "");
                            if (!cleaned.equals(timezoneId)) {
                                v7 = "\ua746\u4cdb\u0b77\uec6c\ue059\ua7d6\ua77a\u7583\ue1ee\u5599\ua643\uc718\u9cae\u8ce7\ucdd7\u4bbe\ua80c\u18e0\uca90\ub31e\u844b\u7b5a\u1b78\uc745\u78e9\u0de4\u4d3f\u10b1\u6a96\u18a6\u5f25\u7128\u2d80".toCharArray();
                                v7[23] = (char)(v7[23] ^ 17032);
                                v8 = "\u435a\ua453\u74ee\u925a\uc726\ua4f5\u9f71\ucdbc\ud2f9\ude99\u392e\ua011\udee6\u2634\u63af\uf7b5\ub79a\u868f\uf442\ue6cc".toCharArray();
                                v8[17] = (char)(v8[17] ^ 29919);
                                throw new IndexOutOfBoundsException(g.Q(v7, 369 << 16 | 25442, (short)3, (short)1) + timezoneId + g.Q(v8, 21730 << 16 | 27765, (short)5, (short)2) + timezone.getID());
                            }
                        }
                    }
                    break block28;
                }
                v9 = "\uc3eb\ufd5b\ub755\u6464\u7533\ucc6a\u57ba\ue412\ufcc8\u9745\u62bc\ufd75\ud066\ub059\u791c\u0a73\ua84c\u5acd\u4712\u771e\ub241\u8d6f\ucb60\ue274\uccd9\u28d8\ua785\u8e22\uc791".toCharArray();
                v9[18] = (char)(v9[18] ^ 17650);
                v10 = "\ue35f".toCharArray();
                v10[0] = (char)(v10[0] ^ 5841);
                throw new IndexOutOfBoundsException(g.Q(v9, 5213 << 16 | 20904, (short)3, (short)3) + timezoneIndicator + g.Q(v10, 22347 << 16 | 27614, (short)2, (short)1));
            }
            calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            pos.setIndex(offset);
            return calendar.getTime();
        }
        catch (IndexOutOfBoundsException e) {
            fail = e;
        }
        catch (NumberFormatException e) {
            fail = e;
        }
        catch (IllegalArgumentException e) {
            fail = e;
        }
        if (date == null) {
            v11 = null;
        } else {
            v12 = "\uc600".toCharArray();
            v12[0] = (char)(v12[0] ^ 1362);
            v11 = '\"' + date + g.Q(v12, 4348 << 16 | 13194, (short)5, (short)5);
        }
        input = v11;
        msg = fail.getMessage();
        if (msg == null || msg.isEmpty()) {
            v13 = "\u17d0".toCharArray();
            v13[0] = (char)(v13[0] ^ 2290);
            v14 = "\u403f".toCharArray();
            v14[0] = (char)(v14[0] ^ 11655);
            msg = g.Q(v13, 14197 << 16 | 30625, (short)1, (short)0) + fail.getClass().getName() + g.Q(v14, 17773 << 16 | 7469, (short)5, (short)0);
        }
        v15 = "\u7b3a\u241b\ud0f9\ud064\ua0d0\u6474\u07be\u3fec\ue139\u8905\u7085\u6841\u6fc8\uad96\u5078\u79e7\u0499\ue2a9\ub9ef\u7de9\ue37a\u4dca".toCharArray();
        v15[4] = (char)(v15[4] ^ 31059);
        v16 = "\u0fe7\u07f4\udea7".toCharArray();
        v16[1] = (char)(v16[1] ^ 3329);
        ex = new ParseException(g.Q(v15, 10648 << 16 | 10459, (short)0, (short)5) + input + g.Q(v16, 26324 << 16 | 22224, (short)5, (short)0) + msg, pos.getIndex());
        ex.initCause(fail);
        throw ex;
    }

    private static boolean checkOffset(String value, int offset, char expected) {
        return offset < value.length() && value.charAt(offset) == expected;
    }

    private static int parseInt(String value, int beginIndex, int endIndex) throws NumberFormatException {
        int digit;
        if (beginIndex < 0 || endIndex > value.length() || beginIndex > endIndex) {
            throw new NumberFormatException(value);
        }
        int i = beginIndex;
        int result = 0;
        if (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                char[] cArray = "\uac41\u72ba\u3d06\uf1fb\u63be\u209c\u1540\u8759\u11e6\u7ad7\u2a6a\ubb41\u56fd\uc0bd\ud3f2\ue096".toCharArray();
                cArray[6] = (char)(cArray[6] ^ 0x5D17);
                throw new NumberFormatException(g.Q(cArray, 15065 << 16 | 0x1538, (short)3, (short)1) + value.substring(beginIndex, endIndex));
            }
            result = -digit;
        }
        while (i < endIndex) {
            if ((digit = Character.digit(value.charAt(i++), 10)) < 0) {
                char[] cArray = "\u971a\u99bf\ua28d\u3f78\ub21d\uebb2\u6fd5\u7ce0\u16c6\u483e\u2c19\ubefb\u0087\u717c\u57b2\u53df".toCharArray();
                cArray[7] = (char)(cArray[7] ^ 0x48EE);
                throw new NumberFormatException(g.Q(cArray, 25324 << 16 | 0x6420, (short)3, (short)1) + value.substring(beginIndex, endIndex));
            }
            result *= 10;
            result -= digit;
        }
        return -result;
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }

    private static int indexOfNonDigit(String string, int offset) {
        for (int i = offset; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '0' && c2 <= '9') continue;
            return i;
        }
        return string.length();
    }

    static {
        char[] cArray = "\ub5d3\uafb3\ucb70".toCharArray();
        cArray[1] = (char)(cArray[1] ^ 0x6AA6);
        UTC_ID = g.Q(cArray, 364 << 16 | 0x14C5, (short)1, (short)3);
        char[] cArray2 = "\u24fb\u5dc6\ua703".toCharArray();
        cArray2[1] = (char)(cArray2[1] ^ 0x2303);
        TIMEZONE_UTC = TimeZone.getTimeZone(g.Q(cArray2, 11778 << 16 | 0x17EB, (short)4, (short)1));
    }
}

