/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.stream;

import com.google.gson.stream.JsonWriter$JsonWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    public JsonWriter(Writer out) {
        this.push(6);
        char[] cArray = "\u19fe".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x7A3C);
        this.separator = JsonWriter$JsonWriter.H(cArray, 32111 << 16 | 0x7F19, 5, 0);
        this.serializeNulls = true;
        if (out == null) {
            char[] cArray2 = "\u8cfd\u39dc\u4825\ud181\u1076\u3270\u98db\u06db\u1c4f\uf10f\u9158".toCharArray();
            cArray2[8] = (char)(cArray2[8] ^ 0x1A93);
            throw new NullPointerException(JsonWriter$JsonWriter.H(cArray2, 16888 << 16 | 0x27E2, 0, 5));
        }
        this.out = out;
    }

    public final void setIndent(String indent) {
        if (indent.length() == 0) {
            this.indent = null;
            char[] cArray = "\uc58a".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x6762);
            this.separator = JsonWriter$JsonWriter.H(cArray, 12916 << 16 | 0x7E58, 2, 0);
        } else {
            this.indent = indent;
            char[] cArray = "\u0f1d\u5d76".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x791D);
            this.separator = JsonWriter$JsonWriter.H(cArray, 18669 << 16 | 0x65AE, 5, 2);
        }
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final void setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        char[] cArray = "\ud6b2".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x1FC4);
        return this.open(1, JsonWriter$JsonWriter.H(cArray, 12498 << 16 | 0x36D7, 0, 3));
    }

    public JsonWriter endArray() throws IOException {
        char[] cArray = "\ub72a".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x2019);
        return this.close(1, 2, JsonWriter$JsonWriter.H(cArray, 8744 << 16 | 0x3AA8, 2, 3));
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        char[] cArray = "\ucc66".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x2EE2);
        return this.open(3, JsonWriter$JsonWriter.H(cArray, 5611 << 16 | 0x77B3, 0, 1));
    }

    public JsonWriter endObject() throws IOException {
        char[] cArray = "\u1a3b".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x6DD3);
        return this.close(3, 5, JsonWriter$JsonWriter.H(cArray, 21028 << 16 | 0x4AAA, 2, 0));
    }

    private JsonWriter open(int empty, String openBracket) throws IOException {
        this.beforeValue();
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private JsonWriter close(int empty, int nonempty, String closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            char[] cArray = "\uc067\u68a4\u8bce\u439d\uf425\u4210\uc26a\u4101\u35b6\u2cb6\u8e4f\uccdb\u5761\ub6ee\uade0\u7046".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x2D2E);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 14379 << 16 | 0x45E8, 1, 1));
        }
        if (this.deferredName != null) {
            char[] cArray = "\uf49f\u4ace\u070a\u28d9\ub6b8\u44ca\u4c6a\uf756\uf0b5\uc129]\ucca4\u952f\uced4\u1107".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0x66E7);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 20163 << 16 | 0x269F, 0, 0) + this.deferredName);
        }
        --this.stackSize;
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            this.stack = newStack;
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            char[] cArray = "\u5e2d\uc261\u1a6a\u1721\u67c6\ube29\u11a8\u7c6e\ue7bc\ub782\u0ec7\u3598\ua93c\uc31f\uf942\u32ee\uc73b\u516b\u79cc\ufde5\u1386".toCharArray();
            cArray[20] = (char)(cArray[20] ^ 0x3C08);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 24395 << 16 | 0x28B8, 2, 3));
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    public JsonWriter name(String name) throws IOException {
        if (name == null) {
            char[] cArray = "\uea99\u7c11\uc076\u3965\ua337\u19f7\u1997\ufe3e\u4ed9\u291f\ue274\u72aa".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x53AD);
            throw new NullPointerException(JsonWriter$JsonWriter.H(cArray, 21689 << 16 | 0x1599, 4, 1));
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            char[] cArray = "\uedb3\u6bf4\u8188\u3692\u6cc0\ub27d\ue7fa\uc227\u62bf\ue39d\u5514\u69d3\u444b\u05d5\u6dd1\u7a35\u4927\uba6a\u0f28\u917d\u08ae".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0x6482);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 10202 << 16 | 0x18FF, 5, 0));
        }
        this.deferredName = name;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value);
        return this;
    }

    public JsonWriter jsonValue(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        char[] cArray = "\u74d8\u8335\u51d8\u4e28".toCharArray();
        cArray[1] = (char)(cArray[1] ^ 0x1988);
        this.out.write(JsonWriter$JsonWriter.H(cArray, 3691 << 16 | 0x67D4, 4, 5));
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        String string;
        this.writeDeferredName();
        this.beforeValue();
        if (value) {
            char[] cArray = "\u2cd2\u01ca\uf87f\u6404".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x2D4E);
            string = JsonWriter$JsonWriter.H(cArray, 2702 << 16 | 0x67BA, 5, 2);
        } else {
            char[] cArray = "\u3353\u6d99\u507d\ud480\ue73f".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x5E0C);
            string = JsonWriter$JsonWriter.H(cArray, 7961 << 16 | 0x4061, 3, 1);
        }
        this.out.write(string);
        return this;
    }

    public JsonWriter value(Boolean value) throws IOException {
        String string;
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        if (value.booleanValue()) {
            char[] cArray = "\ue0aa\ub4b5\u0c67\ua199".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x2267);
            string = JsonWriter$JsonWriter.H(cArray, 17668 << 16 | 0x431E, 2, 2);
        } else {
            char[] cArray = "\ud556\u0566\uda35\u7802\u3d23".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x60E);
            string = JsonWriter$JsonWriter.H(cArray, 4146 << 16 | 0x41C5, 0, 2);
        }
        this.out.write(string);
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            char[] cArray = "\u416c\u73f7\uccac\u98ac\u8284\udf37\u6a20\uf2d6\ua33c\uc453\u69f3\u54b4\u400e\ufd55\u44b3\uc6c8\udc1a\uad5c\u3f1c\u77d7\u1fc2\uc36f\uc55c\ua5ce\u66cf\uf511\ufd05\u94fb\u4eaf\u80fa\ue6e8\u1127\u8e6f\ud7c0\ucbf8\u65cc\uc246\u2727\u687c".toCharArray();
            cArray[15] = (char)(cArray[15] ^ 0x7569);
            throw new IllegalArgumentException(JsonWriter$JsonWriter.H(cArray, 10694 << 16 | 0x63B2, 4, 4) + value);
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(Double.toString(value));
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(value));
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        String string;
        block4: {
            block5: {
                if (value == null) {
                    return this.nullValue();
                }
                this.writeDeferredName();
                string = value.toString();
                if (this.lenient) break block4;
                char[] cArray = "\ud29a\ucfae\u0cc1\ue92a\u778a\u1cb5\u4f86\uaf17\u0ed5".toCharArray();
                cArray[7] = (char)(cArray[7] ^ 0x1380);
                if (string.equals(JsonWriter$JsonWriter.H(cArray, 30707 << 16 | 0x54C, 5, 5))) break block5;
                char[] cArray2 = "\ue413\uf0a7\u6289\u46fb\u6368\uebb8\u5420\u1e52".toCharArray();
                cArray2[1] = (char)(cArray2[1] ^ 0x1A2);
                if (string.equals(JsonWriter$JsonWriter.H(cArray2, 22504 << 16 | 0x1FCE, 4, 3))) break block5;
                char[] cArray3 = "\u0773\u2926\udb1c".toCharArray();
                cArray3[1] = (char)(cArray3[1] ^ 0xF0A);
                if (!string.equals(JsonWriter$JsonWriter.H(cArray3, 18719 << 16 | 0x556B, 3, 0))) break block4;
            }
            char[] cArray = "\ua0a8\u71ad\u3bde\u0211\u3473\uf772\uf94c\ub0a2\u853f\u47ec\u642a\ue6d1\u273f\u8bfb\ud2aa\u7292\u44fc\u1d3e\ub5f7\u8e84\u2bc4\udbf2\uac4d\ucd13\u2939\ub0dd\u2bfb\u6452\u92d2\ua7e0\u12bc\u047f\ua32f\u963b\u4501\ud42a\u1e03\ud43b\u3759".toCharArray();
            cArray[11] = (char)(cArray[11] ^ 0x48F2);
            throw new IllegalArgumentException(JsonWriter$JsonWriter.H(cArray, 28244 << 16 | 0x5C22, 1, 4) + value);
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            char[] cArray = "\uc4ba\u1f53\uad2c\u0b1e\udee8\u5284\uf198\ucc5b\ue080\u3dc5\u7984\ud3a1\u53f2\ued1e\ucbad\u95d6\u9909\ufa44\uae73\ub32e\udc5a".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x7F90);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 7602 << 16 | 0x2790, 5, 3));
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            char[] cArray = "\u7a14\u2195\u3dc7\uad53\uaae3\uf10a\u2f9e\u0fe7\u28d3\u416c\u9f79\uc3bf\u1543\u547c\u230c\u466f\u8291\ua374\u4bc0".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x29AE);
            throw new IOException(JsonWriter$JsonWriter.H(cArray, 29526 << 16 | 0x7E06, 5, 1));
        }
        this.stackSize = 0;
    }

    private void string(String value) throws IOException {
        String[] replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        char[] cArray = "\u10a7".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x1F0B);
        this.out.write(JsonWriter$JsonWriter.H(cArray, 3476 << 16 | 0x4EBD, 4, 1));
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c2 = value.charAt(i);
            if (c2 < '\u0080') {
                replacement = replacements[c2];
                if (replacement == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                char[] cArray2 = "\ue619\u50b0\u8152\u86ad\u3d99\ud456".toCharArray();
                cArray2[0] = (char)(cArray2[0] ^ 0x1728);
                replacement = JsonWriter$JsonWriter.H(cArray2, 20192 << 16 | 0x43F9, 3, 1);
            } else {
                if (c2 != '\u2029') continue;
                char[] cArray3 = ")\ua64c\ub6b5\ud487\u2fa4\u25b4".toCharArray();
                cArray3[0] = (char)(cArray3[0] ^ 0x46CD);
                replacement = JsonWriter$JsonWriter.H(cArray3, 20009 << 16 | 0x39F9, 4, 1);
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement);
            last = i + 1;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        char[] cArray4 = "\u687a".toCharArray();
        cArray4[0] = (char)(cArray4[0] ^ 0x2F07);
        this.out.write(JsonWriter$JsonWriter.H(cArray4, 28560 << 16 | 0x8D7, 5, 5));
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        char[] cArray = "\u61ca".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x106F);
        this.out.write(JsonWriter$JsonWriter.H(cArray, 19097 << 16 | 0x1333, 5, 0));
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (context != 3) {
            char[] cArray = "\u6927\uc123\u5a45\u0b74\ube0c\uf242\u30f2\u6906\uf0d8\ucfa9\u4f7e\u0ca6\ua7ba\uf411\uac4c\ucbca".toCharArray();
            cArray[14] = (char)(cArray[14] ^ 0x1413);
            throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 21692 << 16 | 0x2669, 1, 4));
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    char[] cArray = "\ufde6\u7f95\ud227\u9b68\ueb97\uce58\u3e99\u03ff\u9e57\u9bda\u0c85\uc488\udb49\u1c26\uf988\uded3\ub1fd\ub89b\ue4d4\u32d6\u8352\u74cc\uf899\u53dd\u5c97\ubf76\uada8\ue56a\ub202\u4190\u0ca0\u2549\ue53c\ua82c\u7c43\uf5a5\u022d\uc50d\u4f37\ufdbd".toCharArray();
                    cArray[20] = (char)(cArray[20] ^ 0x5D59);
                    throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 15460 << 16 | 0x6BDF, 3, 5));
                }
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                break;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                char[] cArray = "\uf9aa\ufb78\u7ca5\u6f3a\ubd25\u6b36\u4487\u1369\ua232\ua7e2\u7dd3\ua6e8\ucd6d\u8366\u13eb\ucd7d".toCharArray();
                cArray[0] = (char)(cArray[0] ^ 0x61B);
                throw new IllegalStateException(JsonWriter$JsonWriter.H(cArray, 14988 << 16 | 0x25E, 4, 4));
            }
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            char[] cArray = "\u50b4\u6416\u2a29\ub20f\u2bd8\ub604".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x358E);
            JsonWriter.REPLACEMENT_CHARS[i] = String.format(JsonWriter$JsonWriter.H(cArray, 14161 << 16 | 0x35A, 4, 3), i);
        }
        char[] cArray = "\ua05d\u9bf6".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x373A);
        JsonWriter.REPLACEMENT_CHARS[34] = JsonWriter$JsonWriter.H(cArray, 11062 << 16 | 0x5BE5, 2, 2);
        char[] cArray2 = "\u8fb4\ua535".toCharArray();
        cArray2[0] = (char)(cArray2[0] ^ 0xE0D);
        JsonWriter.REPLACEMENT_CHARS[92] = JsonWriter$JsonWriter.H(cArray2, 30219 << 16 | 0xD85, 4, 5);
        char[] cArray3 = "\udafa\uc2ed".toCharArray();
        cArray3[0] = (char)(cArray3[0] ^ 0x56DA);
        JsonWriter.REPLACEMENT_CHARS[9] = JsonWriter$JsonWriter.H(cArray3, 9005 << 16 | 0x5A95, 5, 2);
        char[] cArray4 = "\uf87e\uc3e5".toCharArray();
        cArray4[1] = (char)(cArray4[1] ^ 0x137B);
        JsonWriter.REPLACEMENT_CHARS[8] = JsonWriter$JsonWriter.H(cArray4, 24973 << 16 | 0xE30, 5, 2);
        char[] cArray5 = "\u1e72\udfae".toCharArray();
        cArray5[1] = (char)(cArray5[1] ^ 0x3630);
        JsonWriter.REPLACEMENT_CHARS[10] = JsonWriter$JsonWriter.H(cArray5, 20986 << 16 | 0x2895, 1, 0);
        char[] cArray6 = "\u55b7\u4af2".toCharArray();
        cArray6[1] = (char)(cArray6[1] ^ 0x164B);
        JsonWriter.REPLACEMENT_CHARS[13] = JsonWriter$JsonWriter.H(cArray6, 2146 << 16 | 0x1001, 1, 5);
        char[] cArray7 = "\u526a\u6727".toCharArray();
        cArray7[1] = (char)(cArray7[1] ^ 0x181A);
        JsonWriter.REPLACEMENT_CHARS[12] = JsonWriter$JsonWriter.H(cArray7, 11309 << 16 | 0x61A, 5, 1);
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        char[] cArray8 = "\u4dc1\u5f4c\ueb71\u1d5e\uf7e2\ucc34".toCharArray();
        cArray8[1] = (char)(cArray8[1] ^ 0x6D3C);
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = JsonWriter$JsonWriter.H(cArray8, 25289 << 16 | 0x3460, 4, 0);
        char[] cArray9 = "\u44a6\uc28a\u06a1\u5a4d\u6611\uf5ed".toCharArray();
        cArray9[5] = (char)(cArray9[5] ^ 0x7BDD);
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = JsonWriter$JsonWriter.H(cArray9, 30426 << 16 | 0x4AE2, 5, 0);
        char[] cArray10 = "\ue3b4\u98b4\u742a\uf900\ue39d\u54f1".toCharArray();
        cArray10[1] = (char)(cArray10[1] ^ 0x7332);
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = JsonWriter$JsonWriter.H(cArray10, 25691 << 16 | 0x77A8, 3, 4);
        char[] cArray11 = "\uddcd\u6497\u3ca3\ue088\u8cf2\u7e8a".toCharArray();
        cArray11[2] = (char)(cArray11[2] ^ 0x2D12);
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = JsonWriter$JsonWriter.H(cArray11, 1937 << 16 | 0x3AB2, 3, 4);
        char[] cArray12 = "\u105b\ub7d2\u2b75\ub031\u8efe\u2a9d".toCharArray();
        cArray12[5] = (char)(cArray12[5] ^ 0x7566);
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = JsonWriter$JsonWriter.H(cArray12, 16405 << 16 | 0x3D15, 2, 3);
    }
}

