/*
 * Decompiled with CFR 0.152.
 */
package elinchrom;

import elinchrom.Elinchrom_Flash_Unit$Unit_Prototype_Json;
import elinchrom.FirmwareVersion$FirmwareVersion;

public class FirmwareVersion {
    private final int _master;
    private final int _slave;
    private final int _ordinal;
    private final String _string;

    public FirmwareVersion(byte master, byte slave) {
        this._master = master & 0xFF;
        this._slave = slave & 0xFF;
        boolean hasSlave = this._slave != 0;
        this._ordinal = hasSlave ? this._master * 1000 + this._slave : this._master / 10 * 1000 + this._master % 10;
        this._string = this.initString();
    }

    public FirmwareVersion(byte version) {
        this(version, 0);
    }

    public FirmwareVersion(String version) {
        char[] cArray = "\uc745\u730a\u6fd8\uf568\u9311\u0c77\ud6f8\ufc59".toCharArray();
        cArray[2] = (char)(cArray[2] ^ 0x413A);
        if (version.matches(Elinchrom_Flash_Unit$Unit_Prototype_Json.j(cArray, 27092 << 16 | 0x1507, 3, (byte)1))) {
            char[] cArray2 = "\u7a53\u5bb6".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x6456);
            String[] m_s = version.split(Elinchrom_Flash_Unit$Unit_Prototype_Json.j(cArray2, 6365 << 16 | 0x4483, 1, (byte)3));
            this._master = Integer.parseInt(m_s[0]);
            this._slave = Integer.parseInt(m_s[1]);
            this._ordinal = Integer.parseInt(m_s[0]) * 1000 + Integer.parseInt(m_s[1]);
            this._string = this.initString();
        } else {
            this._master = 0;
            this._slave = 0;
            this._ordinal = 0;
            this._string = this.initString();
        }
    }

    public boolean isBefore(FirmwareVersion another) {
        return this._ordinal < another._ordinal;
    }

    public boolean isAfter(FirmwareVersion another) {
        return this._ordinal > another._ordinal;
    }

    protected byte getSlave() {
        return (byte)this._slave;
    }

    protected byte getMaster() {
        return (byte)this._master;
    }

    public String toString() {
        return this._string;
    }

    private String initString() {
        if (this._slave != 0) {
            String string;
            String m;
            String string2;
            if (this._master == 255) {
                char[] cArray = "\u7972\u09a7\u7971".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0xBE4);
                string2 = FirmwareVersion$FirmwareVersion.n(cArray, 2982 << 16 | 0x1C2F, (byte)4, true);
            } else {
                string2 = m = Integer.toString(this._master);
            }
            if (this._slave == 255) {
                char[] cArray = "\u6d1b\u851e\u6e91".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x7359);
                string = FirmwareVersion$FirmwareVersion.n(cArray, 29768 << 16 | 0x67A7, (byte)1, true);
            } else {
                string = Integer.toString(this._slave);
            }
            String s = string;
            char[] cArray = "\u1139\ufd73\u42ef\u7cf9\ubda0".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x769D);
            return String.format(FirmwareVersion$FirmwareVersion.n(cArray, 12213 << 16 | 0x4046, (byte)2, false), m, s);
        }
        if (this._master == 255) {
            char[] cArray = "\u2f51\uceaa\u00de".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x125D);
            return FirmwareVersion$FirmwareVersion.n(cArray, 18283 << 16 | 0x37F9, (byte)5, false);
        }
        char[] cArray = "\ue167\ua6b9\uad51\u819a\u6c1a".toCharArray();
        cArray[4] = (char)(cArray[4] ^ 0x5A80);
        return String.format(FirmwareVersion$FirmwareVersion.n(cArray, 9552 << 16 | 0x3688, (byte)4, true), this._master / 10, this._master % 10);
    }
}

