/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import org.hid4java.HidManager$HidManager;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidDeviceStructure;

public class HidDevice {
    private HidDeviceStructure hidDeviceStructure = null;
    private String path;
    private short vendorId;
    private short productId;
    private String serialNumber;
    private int releaseNumber;
    private String manufacturer;
    private String product;
    private int usagePage;
    private int usage;
    private int interfaceNumber;

    public HidDevice(HidDeviceInfoStructure infoStructure) {
        this.path = infoStructure.path;
        this.vendorId = infoStructure.vendor_id;
        this.productId = infoStructure.product_id;
        this.releaseNumber = infoStructure.release_number;
        if (infoStructure.serial_number != null) {
            this.serialNumber = infoStructure.serial_number.toString();
        }
        if (infoStructure.manufacturer_string != null) {
            this.manufacturer = infoStructure.manufacturer_string.toString();
        }
        if (infoStructure.product_string != null) {
            this.product = infoStructure.product_string.toString();
        }
        this.usagePage = infoStructure.usage_page;
        this.usage = infoStructure.usage;
        this.interfaceNumber = infoStructure.interface_number;
    }

    public String getId() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public short getVendorId() {
        return this.vendorId;
    }

    public short getProductId() {
        return this.productId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getProduct() {
        return this.product;
    }

    public int getUsagePage() {
        return this.usagePage;
    }

    public int getUsage() {
        return this.usage;
    }

    public int getInterfaceNumber() {
        return this.interfaceNumber;
    }

    public String toString() {
        char[] cArray = "\u50b1\uae71\uc418\u654d\u081a\uc946\uc1eb\uaa3a\u008a\u2d0c\u2031\u8526\ufdd8\u8988\u35d7\u78da".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x2981);
        char[] cArray2 = "\u7e77\ucaf2\u139a\ufbf8\u7b47\u693a\u1856\ubae0\u5054\u6678\ucae4\u8c6d\u24ec".toCharArray();
        cArray2[10] = (char)(cArray2[10] ^ 0x1B35);
        char[] cArray3 = "\ue325\ue621\u497f\u41d1\ud7e2\u7513\u306a\uc420\u0674\u93b3\u8806\uf5dc\u3f50\u557d".toCharArray();
        cArray3[8] = (char)(cArray3[8] ^ 0x73F1);
        char[] cArray4 = "\u3033\ua375\u4a03\u19b9\u8fbf\u89e4\u01a1\u9084\u1e3a\u5d8d\u252f\ue967\ua7b0\u6427\u9187".toCharArray();
        cArray4[7] = (char)(cArray4[7] ^ 0x2309);
        char[] cArray5 = "\ua93a\u3183\u8e5e\u564e\ub950\uee26\uc649\u5677\ub44f\uee40\u5d90\ub2d2\u16a1\u62b6\u4598\uf6e4\u9119\u1b63".toCharArray();
        cArray5[16] = (char)(cArray5[16] ^ 0x5653);
        char[] cArray6 = "\ua717\u04d0\u3254\u5644\u17e4\ucb63\u23e8\u9eb7\u317f\u000b\u1e30\u036c\uc218\u0ef5\uf7a6".toCharArray();
        cArray6[12] = (char)(cArray6[12] ^ 0x5C1E);
        char[] cArray7 = "\uda7e\ud7ba\uae15\u52f7\ua69c\u3a0b\u1d14\u08f0\u6513\u3c87".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0x295);
        char[] cArray8 = "\ue5b1\u4992\ua15f\u7381\u2185\u0a49\uf653\u74d9\u75cc\uc42f\u3a3e\u834a\u48ed\u44c4".toCharArray();
        cArray8[7] = (char)(cArray8[7] ^ 0x5A68);
        char[] cArray9 = "\u8314\ucd9c\u61c7\ue300\u73f2\uf927\uc1f0\u73ea\uba24\u0e80".toCharArray();
        cArray9[1] = (char)(cArray9[1] ^ 0x1832);
        char[] cArray10 = "\uf672\uf063\u0cfb\u3d64\u2c0d\ud0ce\u3b27\uf454\u091c\u69e9\ucf4b\u3bb6\ua730\u264e\u6ce0\u78f5\u04e0\u3f95".toCharArray();
        cArray10[9] = (char)(cArray10[9] ^ 0x1A4);
        char[] cArray11 = "\u1a52".toCharArray();
        cArray11[0] = (char)(cArray11[0] ^ 0x5685);
        return HidManager$HidManager.U(cArray, 12797 << 16 | 0x678F, false, (short)4) + this.path + HidManager$HidManager.U(cArray2, 16769 << 16 | 0x3B93, true, (short)5) + Integer.toHexString(this.vendorId) + HidManager$HidManager.U(cArray3, 22524 << 16 | 0x5444, true, (short)1) + Integer.toHexString(this.productId) + HidManager$HidManager.U(cArray4, 6749 << 16 | 0x52D8, true, (short)4) + this.serialNumber + HidManager$HidManager.U(cArray5, 18419 << 16 | 0x344D, false, (short)0) + Integer.toHexString(this.releaseNumber) + HidManager$HidManager.U(cArray6, 22037 << 16 | 0x870, false, (short)2) + this.manufacturer + HidManager$HidManager.U(cArray7, 22173 << 16 | 0x7604, false, (short)2) + this.product + HidManager$HidManager.U(cArray8, 20302 << 16 | 0x66C8, true, (short)4) + Integer.toHexString(this.usagePage) + HidManager$HidManager.U(cArray9, 4943 << 16 | 0x5E95, false, (short)2) + Integer.toHexString(this.usage) + HidManager$HidManager.U(cArray10, 2369 << 16 | 0x31AC, false, (short)5) + this.interfaceNumber + HidManager$HidManager.U(cArray11, 16897 << 16 | 0x463F, true, (short)5);
    }

    public int write(byte[] message, int packetLength, byte reportId) {
        return HidApi.write(this.hidDeviceStructure, message, packetLength, reportId);
    }

    public String getLastErrorMessage() {
        return HidApi.getLastErrorMessage(this.hidDeviceStructure);
    }

    public boolean open() {
        this.hidDeviceStructure = HidApi.open(this.path);
        return this.hidDeviceStructure != null;
    }

    public void close() {
        HidApi.close(this.hidDeviceStructure);
        this.hidDeviceStructure = null;
    }

    public void setNonBlocking(boolean nonBlocking) {
        HidApi.setNonBlocking(this.hidDeviceStructure, nonBlocking);
    }

    public int read(byte[] data) {
        return HidApi.read(this.hidDeviceStructure, data);
    }

    public int read(byte[] bytes, int timeoutMillis) {
        return HidApi.read(this.hidDeviceStructure, bytes, timeoutMillis);
    }

    public int getFeatureReport(byte[] data, byte reportId) {
        return HidApi.getFeatureReport(this.hidDeviceStructure, data, reportId);
    }

    public int sendFeatureReport(byte[] data, byte reportId) {
        return HidApi.sendFeatureReport(this.hidDeviceStructure, data, reportId);
    }

    public String getIndexedString(int index) {
        return HidApi.getIndexedString(this.hidDeviceStructure, index);
    }

    public boolean isOpen() {
        return this.hidDeviceStructure != null;
    }

    public boolean isVidPidSerial(int vendorId, int productId, String serialNumber) {
        return !(vendorId != 0 && this.vendorId != vendorId || productId != 0 && this.productId != productId || serialNumber != null && !this.serialNumber.equals(serialNumber));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HidDevice hidDevice = (HidDevice)o;
        return this.path.equals(hidDevice.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

