/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java.jna;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import org.hid4java.jna.HidApiLibrary;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidDeviceStructure;
import org.hid4java.jna.WideStringBuffer;
import org.hid4java.jna.WideStringBuffer$HidDeviceStructure;

public class HidApi {
    private static int WSTR_LEN;
    private static final String DEVICE_NULL;
    private static final int DEVICE_ERROR = -2;
    private static final HidApiLibrary hidApiLibrary;

    public static HidDeviceStructure open(int vendor, int product, String serialNumber) {
        Pointer p = hidApiLibrary.hid_open((short)vendor, (short)product, serialNumber == null ? null : new WString(serialNumber));
        if (p != null) {
            return new HidDeviceStructure(p);
        }
        return null;
    }

    public static void init() {
        hidApiLibrary.hid_init();
    }

    public static void exit() {
        hidApiLibrary.hid_exit();
    }

    public static HidDeviceStructure open(String path) {
        Pointer p = hidApiLibrary.hid_open_path(path);
        return p == null ? null : new HidDeviceStructure(p);
    }

    public static void close(HidDeviceStructure device) {
        if (device != null) {
            hidApiLibrary.hid_close(device.ptr());
        }
    }

    public static HidDeviceInfoStructure enumerateDevices(int vendor, int product) {
        return hidApiLibrary.hid_enumerate((short)vendor, (short)product);
    }

    public static void freeEnumeration(HidDeviceInfoStructure list) {
        hidApiLibrary.hid_free_enumeration(list.getPointer());
    }

    public static String getLastErrorMessage(HidDeviceStructure device) {
        if (device == null) {
            char[] cArray = "\ue9f2\uf46e\u74f3\ufe1e\u9f7c\ufab4\u97fa\u9d9c\u5e98\u8eaa\u062b\u1b29\uedad\uedc2\u83ef\uc97b\u8925\u7124\u5838\u5299\u74d5\u8987".toCharArray();
            cArray[5] = (char)(cArray[5] ^ 0x230);
            return WideStringBuffer$HidDeviceStructure.H(cArray, 3877 << 16 | 0x649E, 1, (byte)1);
        }
        Pointer p = hidApiLibrary.hid_error(device.ptr());
        return p == null ? null : new WideStringBuffer(p.getByteArray(0L, WSTR_LEN)).toString();
    }

    public static String getManufacturer(HidDeviceStructure device) {
        if (device == null) {
            char[] cArray = "\u9a93\u8682\u2969\ud182\u7a8f\u7e7e\u13f2\uc87a\ufbbe\ub19f\udee4\uc85b\ud25d\uc390\u0950\ufd51\u87b2\u9d78\u683d\u0a4f\u0ede\uc923".toCharArray();
            cArray[21] = (char)(cArray[21] ^ 0x766);
            return WideStringBuffer$HidDeviceStructure.H(cArray, 15898 << 16 | 0x7108, 4, (byte)2);
        }
        WideStringBuffer wStr = new WideStringBuffer(WSTR_LEN);
        hidApiLibrary.hid_get_manufacturer_string(device.ptr(), wStr, WSTR_LEN);
        return wStr.toString();
    }

    public static String getProductId(HidDeviceStructure device) {
        if (device == null) {
            char[] cArray = "\ucd60\u12c1\ueac9\u0ad2\uae6a\u698d\ud47b\uf604\u2707\u7feb\u5808\u4f60\udfd8\u5160\u0a71\u064a\u163b\uc5d3\ub0f8\u4aeb\uacb4\u7ffd".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x46);
            return WideStringBuffer$HidDeviceStructure.H(cArray, 13643 << 16 | 0x3AA1, 2, (byte)4);
        }
        WideStringBuffer wBuffer = new WideStringBuffer(WSTR_LEN);
        hidApiLibrary.hid_get_product_string(device.ptr(), wBuffer, WSTR_LEN);
        return wBuffer.toString();
    }

    public static String getSerialNumber(HidDeviceStructure device) {
        if (device == null) {
            char[] cArray = "\u59ba\ubd40\ub175\u9c7f\u53ed\u26df\u43b1\u4348\u50fa\u683d\ua504\u3908\ub4d4\u2530\ua2dc\u319c\u15d3\uc1a5\u30c0\ud82a\u9572\uea4d".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x7AF7);
            return WideStringBuffer$HidDeviceStructure.H(cArray, 10574 << 16 | 0x559A, 1, (byte)3);
        }
        WideStringBuffer wBuffer = new WideStringBuffer(WSTR_LEN);
        hidApiLibrary.hid_get_serial_number_string(device.ptr(), wBuffer, WSTR_LEN);
        return wBuffer.toString();
    }

    public static boolean setNonBlocking(HidDeviceStructure device, boolean nonBlocking) {
        return device != null && 0 == hidApiLibrary.hid_set_nonblocking(device.ptr(), nonBlocking ? 1 : 0);
    }

    public static int read(HidDeviceStructure device, byte[] buffer) {
        if (device == null || buffer == null) {
            return -2;
        }
        WideStringBuffer wBuffer = new WideStringBuffer(buffer);
        return hidApiLibrary.hid_read(device.ptr(), wBuffer, wBuffer.buffer.length);
    }

    public static int read(HidDeviceStructure device, byte[] buffer, int timeoutMillis) {
        if (device == null || buffer == null) {
            return -2;
        }
        WideStringBuffer wBuffer = new WideStringBuffer(buffer);
        return hidApiLibrary.hid_read_timeout(device.ptr(), wBuffer, buffer.length, timeoutMillis);
    }

    public static int getFeatureReport(HidDeviceStructure device, byte[] data, byte reportId) {
        if (device == null || data == null) {
            return -2;
        }
        WideStringBuffer report = new WideStringBuffer(WSTR_LEN);
        report.buffer[0] = reportId;
        int res = hidApiLibrary.hid_get_feature_report(device.ptr(), report, data.length + 1);
        if (res == -1) {
            return res;
        }
        System.arraycopy(report.buffer, 1, data, 0, res > data.length ? data.length : res);
        return res;
    }

    public static int sendFeatureReport(HidDeviceStructure device, byte[] data, byte reportId) {
        if (device == null || data == null) {
            return -2;
        }
        WideStringBuffer report = new WideStringBuffer(data.length + 1);
        report.buffer[0] = reportId;
        System.arraycopy(data, 0, report.buffer, 1, data.length);
        return hidApiLibrary.hid_send_feature_report(device.ptr(), report, report.buffer.length);
    }

    public static int write(HidDeviceStructure device, byte[] data, int len, byte reportId) {
        WideStringBuffer report;
        if (device == null || data == null) {
            return -2;
        }
        if (data.length < len) {
            len = data.length;
        }
        if (Platform.isWindows() && reportId == 0) {
            report = new WideStringBuffer(len);
            if (len > 1) {
                System.arraycopy(data, 0, report.buffer, 0, len);
            }
        } else {
            report = new WideStringBuffer(len + 1);
            report.buffer[0] = reportId;
            if (len > 1) {
                System.arraycopy(data, 0, report.buffer, 1, len);
            }
        }
        return hidApiLibrary.hid_write(device.ptr(), report, report.buffer.length);
    }

    public static String getIndexedString(HidDeviceStructure device, int idx) {
        if (device == null) {
            char[] cArray = "\u79cf\u25da\u42c8\ue72b\ua655\uc1f6\ue3b1\u5e40\ue906\ua78a\uea85\ub133\u707d\uaf69\u599b\u0b87\u5929\uce45\u844b\ude50\u14d0\u1ba8".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x40E0);
            return WideStringBuffer$HidDeviceStructure.H(cArray, 21535 << 16 | 0x713F, 4, (byte)2);
        }
        WideStringBuffer wStr = new WideStringBuffer(WSTR_LEN);
        int res = hidApiLibrary.hid_get_indexed_string(device.ptr(), idx, wStr, WSTR_LEN);
        return res == -1 ? null : wStr.toString();
    }

    static {
        char[] cArray = "\u89b6\u855d\uc7fc\u2ade\u968d\u6e7a\u6b54\u3ca8\u4a03\u9a20\u5ebf\ud276\ud4c5\udc59\ue326\u654e\u6002\uf328\u92af\ud4f7\ue540\u8287".toCharArray();
        cArray[18] = (char)(cArray[18] ^ 0x1C82);
        DEVICE_NULL = WideStringBuffer$HidDeviceStructure.H(cArray, 24447 << 16 | 0x273, 0, (byte)5);
        WSTR_LEN = 512;
        hidApiLibrary = HidApiLibrary.INSTANCE;
    }
}

