/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;

public final class EndpointDescriptor {
    private long endpointDescriptorPointer;

    EndpointDescriptor() {
    }

    public long getPointer() {
        return this.endpointDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native byte bEndpointAddress();

    public native byte bmAttributes();

    public native short wMaxPacketSize();

    public native byte bInterval();

    public native byte bRefresh();

    public native byte bSynchAddress();

    public native ByteBuffer extra();

    public native int extraLength();

    public String dump() {
        return String.format("%s  extralen %17d%n  extra:%n%s", DescriptorUtils.dump(this), this.extraLength(), DescriptorUtils.dump(this.extra()).replaceAll("(?m)^", "    "));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bEndpointAddress()).append(this.bmAttributes()).append(this.wMaxPacketSize()).append(this.bInterval()).append(this.bRefresh()).append(this.bSynchAddress()).append(this.extra()).append(this.extraLength()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointDescriptor other = (EndpointDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bEndpointAddress(), other.bEndpointAddress()).append(this.bmAttributes(), other.bmAttributes()).append(this.wMaxPacketSize(), other.wMaxPacketSize()).append(this.bInterval(), other.bInterval()).append(this.bRefresh(), other.bRefresh()).append(this.bSynchAddress(), other.bSynchAddress()).append(this.extra(), other.extra()).append(this.extraLength(), other.extraLength()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

